<?php
// Deklaracja uniwersalnej funkcji rozwizujcej problemy rnic w znakach przejcia do nowego wiersza.
// $subject cig znakw do konwersji; $type  podany format docelowy. 
// Moe mie jedn z wartoci 'unix', 'mac' lub 'pc'.
function line_break_set($subject, $type) {
    // Okrelenie typu operacji zastpowania.
    switch ($type) {
        case 'mac':
            $ending = '\r';
            break;
        case 'pc':
            $ending = '\r\n';
            break;
        default:
            $ending = '\n';
    }

    // Wykonanie operacji zastpowania.
    return preg_replace('/\r\n|\n\r|\n|\r/', $ending, $subject);
}

$str = "W tym\rcigu znakw\n\ruyto kilku typw\r\nznakw przejcia
do nowego wiersza.\n\nWidzicie?";

// Trzykrotna konwersja cigu.
$mac = line_break_set($str, 'mac');
$unix = line_break_set($str, 'unix');
$pc = line_break_set($str, 'pc');

// Wywietlenie cigu znakw. Wykorzystanie funkcji addcslashes po to, by znaki przejcia do nowego wiersza byy 
// widoczne.
echo '<pre>mac = ', addcslashes($mac, "\n\r"), "\npc = ",
    addcslashes($pc, "\n\r"), "\nunix = ",
    addcslashes($unix, "\n\r"), '</pre>';
?>
